import React, { useEffect } from 'react';
import { BrowserRouter, Routes, Route, useLocation, useParams, useNavigate, Link } from 'react-router-dom';
import './App2.css';

// Import your theme components using @ alias
import FloralTheme from '@/context/themes/floral theme';
import SimpleTheme from '@/context/themes/simpleTheme';
import FiresideCabinTheme from '@/context/themes/firesideCabinTheme';
import BriskNightTheme from '@/context/themes/briskNightTheme';
import LandingPage from '@/components/LandingPage';
import SignUp from '@/components/SignUp';
import Login from '@/components/Login';
import HomePageLayout from '@/components/HomePageLayout';
import { useTheme, ThemeVariant } from '@/context/ThemeContext';
import { useAuth } from '@/context/AuthContext';

// Define types for theme options
// type ThemeMode = 'light' | 'dusky'; // This is available from ThemeContext if needed, or use currentMode directly

// Theme component mapping is no longer needed
/*
const themeComponents = {
  floral: FloralTheme,
  simple: SimpleTheme,
  cabin: FiresideCabinTheme,
  nightSky: BriskNightTheme,
};
*/

function ThemeWrapper() {
  const { setCurrentVariant } = useTheme();
  const params = useParams<{theme: string}>();
  
  useEffect(() => {
    if (params.theme) {
      // Map URL paths to theme variants
      const themeMap: Record<string, ThemeVariant> = {
        'floral': 'floral',
        'simple': 'simple',
        'cabin': 'cabin',
        // Ensure URL path 'nightsky' maps to 'nightSky' ThemeVariant
        'nightsky': 'nightSky' 
      };
      
      const potentialVariant = params.theme.toLowerCase();
      if (themeMap[potentialVariant]) {
        setCurrentVariant(themeMap[potentialVariant]);
      }
      // Optional: handle invalid theme in URL, e.g., navigate to a default or 404
    }
  }, [params.theme, setCurrentVariant]);
  
  return <HomePageLayout />;
}

function App2() {
  return (
    <BrowserRouter>
      <Routes>
        <Route path="/" element={<LandingPage />} />
        <Route path="/home" element={<HomePageLayout />} />
        <Route path="/about" element={<HomePageLayout />} />
        <Route path="/videos" element={<HomePageLayout />} />
        <Route path="/videos/guided" element={<HomePageLayout />} />
        <Route path="/videomap" element={<HomePageLayout />} />
        <Route path="/videomap/video1a" element={<HomePageLayout />} />
        <Route path="/videomap/video2a" element={<HomePageLayout />} />
        <Route path="/videomap/video2b" element={<HomePageLayout />} />
        <Route path="/:theme" element={<ThemeWrapper />} />
        <Route path="/signup" element={<SignUp />} />
        <Route path="/login" element={<Login />} />
      </Routes>
    </BrowserRouter>
  );
}

export default App2; 